/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.ConnectionPointManager;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.core.io.auth.IAuthenticationManager;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import com.aptana.ide.core.io.internal.DeleteResourceShortcutListener;
import com.aptana.ide.core.io.internal.auth.AuthenticationManager;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class CoreIOPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.core.io";
    private static CoreIOPlugin plugin;
    private Map<Object, ConnectionContext> connectionContexts = new WeakHashMap<Object, ConnectionContext>();
    private DeleteResourceShortcutListener deleteListener;
    private IConnectionPointListener listener;
    private IAuthenticationManager fAuthManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            IPath location;
            ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)CoreIOPlugin.getDefault(), (ISaveParticipant)new WorkspaceSaveParticipant());
            if (lastState != null && (location = lastState.lookup((IPath)new Path("connections"))) != null) {
                ConnectionPointManager.getInstance().loadState(this.getStateLocation().append(location));
            }
        }
        catch (IllegalStateException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CoreIOPlugin.getDefault(), (Throwable)e);
        }
        Job job = new Job("Initializing Core IO plugin"){

            protected IStatus run(IProgressMonitor monitor) {
                CoreIOPlugin.this.deleteListener = new DeleteResourceShortcutListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)CoreIOPlugin.this.deleteListener, 1);
                CoreIOPlugin.this.listener = new IConnectionPointListener(){

                    public void connectionPointChanged(ConnectionPointEvent event) {
                        SaveManager saveManager = ((Workspace)ResourcesPlugin.getWorkspace()).getSaveManager();
                        new DelayedSnapshotJob(saveManager).schedule();
                    }
                };
                CoreIOPlugin.getConnectionPointManager().addConnectionPointListener(CoreIOPlugin.this.listener);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.deleteListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.deleteListener);
                this.deleteListener = null;
            }
            ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
            if (this.listener != null) {
                CoreIOPlugin.getConnectionPointManager().removeConnectionPointListener(this.listener);
                this.listener = null;
            }
            this.connectionContexts.clear();
        }
        finally {
            this.fAuthManager = null;
            plugin = null;
            super.stop(context);
        }
    }

    public static CoreIOPlugin getDefault() {
        return plugin;
    }

    public static IConnectionPointManager getConnectionPointManager() {
        return ConnectionPointManager.getInstance();
    }

    public static IAuthenticationManager getAuthenticationManager() {
        return CoreIOPlugin.getDefault().getAuthManager();
    }

    public synchronized IAuthenticationManager getAuthManager() {
        if (this.fAuthManager == null) {
            this.fAuthManager = new AuthenticationManager();
        }
        return this.fAuthManager;
    }

    public static void setConnectionContext(Object key, ConnectionContext context) {
        CoreIOPlugin.getDefault().connectionContexts.put(key, context);
    }

    public static void clearConnectionContext(Object key) {
        CoreIOPlugin.getDefault().connectionContexts.remove(key);
    }

    public static ConnectionContext getConnectionContext(Object key) {
        return CoreIOPlugin.getDefault().connectionContexts.get(key);
    }

    private class WorkspaceSaveParticipant
    implements ISaveParticipant {
        private WorkspaceSaveParticipant() {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void saving(ISaveContext context) throws CoreException {
            IPath savePath = new Path("connections").addFileExtension(Integer.toString(context.getSaveNumber()));
            ConnectionPointManager.getInstance().saveState(CoreIOPlugin.this.getStateLocation().append(savePath));
            context.map((IPath)new Path("connections"), savePath);
            context.needSaveNumber();
        }

        public void doneSaving(ISaveContext context) {
            IPath prevSavePath = new Path("connections").addFileExtension(Integer.toString(context.getPreviousSaveNumber()));
            CoreIOPlugin.this.getStateLocation().append(prevSavePath).toFile().delete();
        }

        public void rollback(ISaveContext context) {
            IPath savePath = new Path("connections").addFileExtension(Integer.toString(context.getSaveNumber()));
            CoreIOPlugin.this.getStateLocation().append(savePath).toFile().delete();
        }
    }
}

